local e=require"nixio"
local u=require"luci.util"
local c=require"table"
local s=require"string"
local a=require"coroutine"
local t=assert
local r=tonumber
local h=tostring
local m=error
local d=type
local y=pairs
local o=ipairs
local w=next
local f=pcall
local o=e.bit.band
local i=e.bit.bor
local n=e.bit.rshift
local s=s.char
local l=getmetatable
module"luci.json"
function decode(t,...)
local e=ActiveDecoder(function()return nil end,...)
e.chunk=t
local e,t=f(e.get,e)
return e and t or nil
end
function encode(t,...)
local e={}
local o=Encoder(t,1,...):source()
local t,a
repeat
t,a=o()
e[#e+1]=t
until not t
return not a and c.concat(e)or nil
end
function null()
return null
end
Encoder=u.class()
function Encoder.__init__(e,t,a,o)
e.data=t
e.buffersize=a or 512
e.buffer=""
e.fastescape=o
l(e).__call=Encoder.source
end
function Encoder.source(e)
local t=a.create(e.dispatch)
return function()
local t,e=a.resume(t,e,e.data,true)
if t then
return e
else
return nil,e
end
end
end
function Encoder.dispatch(e,t,i)
local o=e.parsers[d(t)]
o(e,t)
if i then
if#e.buffer>0 then
a.yield(e.buffer)
end
a.yield()
end
end
function Encoder.put(e,t)
if e.buffersize<2 then
a.yield(t)
else
if#e.buffer+#t>e.buffersize then
local o=0
local i=e.buffersize-#e.buffer
a.yield(e.buffer..t:sub(o+1,i))
o=i
while#t-o>e.buffersize do
i=o+e.buffersize
a.yield(t:sub(o+1,i))
o=i
end
e.buffer=t:sub(o+1)
else
e.buffer=e.buffer..t
end
end
end
function Encoder.parse_nil(e)
e:put("null")
end
function Encoder.parse_bool(t,e)
t:put(e and"true"or"false")
end
function Encoder.parse_number(t,e)
t:put(h(e))
end
function Encoder.parse_string(e,t)
if e.fastescape then
e:put('"'..t:gsub('\\','\\\\'):gsub('"','\\"')..'"')
else
e:put('"'..
t:gsub('[%c\\"]',
function(e)
return'\\u00%02x'%e:byte()
end
)
..'"')
end
end
function Encoder.parse_iter(e,t)
if t==null then
return e:put("null")
end
if d(t)=="table"and(#t==0 and w(t))then
e:put("{")
local a=true
for t,o in y(t)do
if t~=null then
a=a or e:put(",")
a=a and false
e:parse_string(h(t))
e:put(":")
e:dispatch(o)
end
end
e:put("}")
else
e:put("[")
local a=true
if d(t)=="table"then
for o=1,#t do
a=a or e:put(",")
a=a and nil
e:dispatch(t[o])
end
else
for t in t do
a=a or e:put(",")
a=a and nil
e:dispatch(t)
end
end
e:put("]")
end
end
function Encoder.parse_udata(t,e)
return t:parse_string(h(e))
end
Encoder.parsers={
['nil']=Encoder.parse_nil,
['table']=Encoder.parse_iter,
['number']=Encoder.parse_number,
['string']=Encoder.parse_string,
['boolean']=Encoder.parse_bool,
['function']=Encoder.parse_iter,
['userdata']=Encoder.parse_udata,
}
Decoder=u.class()
function Decoder.__init__(e,t)
e.cnull=t
l(e).__call=Decoder.sink
end
function Decoder.sink(e)
local t=a.create(e.dispatch)
return function(...)
return a.resume(t,e,...)
end
end
function Decoder.get(e)
return e.data
end
function Decoder.dispatch(a,e,s,h)
local r,i
local n=false
while e do
while e and#e<1 do
e=a:fetch()
end
t(not h or e,"Unexpected EOS")
if not e then break end
local o=e:sub(1,1)
local o=a.parsers[o]
or(o:match("%s")and a.parse_space)
or(o:match("[0-9-]")and a.parse_number)
or m("Unexpected char '%s'"%o)
e,r=o(a,e)
if o~=a.parse_space then
t(not n,"Scope violation: Too many objects")
i=r
n=true
if h then
return e,i
end
end
end
t(not s,s)
t(n,"Unexpected EOS")
a.data=i
end
function Decoder.fetch(e)
local o,e,a=a.yield()
t(e or not a,a)
return e
end
function Decoder.fetch_atleast(o,e,a)
while#e<a do
local a=o:fetch()
t(a,"Unexpected EOS")
e=e..a
end
return e
end
function Decoder.fetch_until(o,e,i)
local a=e:find(i)
while not a do
local o=o:fetch()
t(o,"Unexpected EOS")
e=e..o
a=e:find(i)
end
return e,a
end
function Decoder.parse_space(a,e)
local t=e:find("[^%s]")
while not t do
e=a:fetch()
if not e then
return nil
end
t=e:find("[^%s]")
end
return e:sub(t)
end
function Decoder.parse_literal(i,e,a,o)
e=i:fetch_atleast(e,#a)
t(e:sub(1,#a)==a,"Invalid character sequence")
return e:sub(#a+1),o
end
function Decoder.parse_null(e,t)
return e:parse_literal(t,"null",e.cnull and null)
end
function Decoder.parse_true(e,t)
return e:parse_literal(t,"true",true)
end
function Decoder.parse_false(e,t)
return e:parse_literal(t,"false",false)
end
function Decoder.parse_number(e,a)
local a,o=e:fetch_until(a,"[^0-9eE.+-]")
local e=r(a:sub(1,o-1))
t(e,"Invalid number specification")
return a:sub(o),e
end
function Decoder.parse_string(i,e)
local a=""
local n=nil
t(e:sub(1,1)=='"','Expected "')
e=e:sub(2)
while true do
local o=e:find('[\\"]')
if o then
a=a..e:sub(1,o-1)
local t=e:sub(o,o)
if t=='"'then
e=e:sub(o+1)
break
elseif t=="\\"then
e,n=i:parse_escape(e:sub(o))
a=a..n
end
else
a=a..e
e=i:fetch()
t(e,"Unexpected EOS while parsing a string")
end
end
return e,a
end
function Decoder.utf8_encode(a,e,t)
local e=e*256+t
if e>=0 and e<=127 then
return s(e)
elseif e>=0 and e<=2047 then
return s(
i(o(n(e,6),31),192),
i(o(e,63),128)
)
elseif e>=0 and e<=65535 then
return s(
i(o(n(e,12),15),224),
i(o(n(e,6),63),128),
i(o(e,63),128)
)
elseif e>=0 and e<=1114111 then
return s(
i(o(n(e,18),7),240),
i(o(n(e,12),63),128),
i(o(n(e,6),63),128),
i(o(e,63),128)
)
else
return"?"
end
end
function Decoder.parse_escape(i,e)
local a=""
e=i:fetch_atleast(e:sub(2),1)
local a=e:sub(1,1)
e=e:sub(2)
if a=='"'then
return e,'"'
elseif a=="\\"then
return e,"\\"
elseif a=="u"then
e=i:fetch_atleast(e,4)
local o,a=e:sub(1,2),e:sub(3,4)
o,a=r(o,16),r(a,16)
t(o and a,"Invalid Unicode character")
return e:sub(5),i:utf8_encode(o,a)
elseif a=="/"then
return e,"/"
elseif a=="b"then
return e,"\b"
elseif a=="f"then
return e,"\f"
elseif a=="n"then
return e,"\n"
elseif a=="r"then
return e,"\r"
elseif a=="t"then
return e,"\t"
else
m("Unexpected escaping sequence '\\%s'"%a)
end
end
function Decoder.parse_array(n,e)
e=e:sub(2)
local i={}
local o=1
local e,a=n:parse_delimiter(e,"%]")
if a then
return e,i
end
repeat
e,a=n:dispatch(e,nil,true)
c.insert(i,o,a)
o=o+1
e,a=n:parse_delimiter(e,",%]")
t(a,"Delimiter expected")
until a=="]"
return e,i
end
function Decoder.parse_object(o,e)
e=e:sub(2)
local i={}
local n
local e,a=o:parse_delimiter(e,"}")
if a then
return e,i
end
repeat
e=o:parse_space(e)
t(e,"Unexpected EOS")
e,n=o:parse_string(e)
e,a=o:parse_delimiter(e,":")
t(a,"Separator expected")
e,a=o:dispatch(e,nil,true)
i[n]=a
e,a=o:parse_delimiter(e,",}")
t(a,"Delimiter expected")
until a=="}"
return e,i
end
function Decoder.parse_delimiter(o,e,i)
while true do
e=o:fetch_atleast(e,1)
local a=e:sub(1,1)
if a:match("%s")then
e=o:parse_space(e)
t(e,"Unexpected EOS")
elseif a:match("[%s]"%i)then
return e:sub(2),a
else
return e,nil
end
end
end
Decoder.parsers={
['"']=Decoder.parse_string,
['t']=Decoder.parse_true,
['f']=Decoder.parse_false,
['n']=Decoder.parse_null,
['[']=Decoder.parse_array,
['{']=Decoder.parse_object
}
ActiveDecoder=u.class(Decoder)
function ActiveDecoder.__init__(e,t,a)
Decoder.__init__(e,a)
e.source=t
e.chunk=nil
l(e).__call=e.get
end
function ActiveDecoder.get(e)
local t,a,o
if not e.chunk then
t,a=e.source()
else
t=e.chunk
end
e.chunk,o=e:dispatch(t,a,true)
return o
end
function ActiveDecoder.fetch(e)
local a,e=e.source()
t(a or not e,e)
return a
end
