local a=require"luci.util"
local e=require"coroutine"
local o=require"table"
local t=require"lucihttp"
local f=require"nixio"
local l=require"luci.ltn12"
local h,r,o,s,n,c,i=
o,ipairs,pairs,type,tostring,tonumber,error
module"luci.http"
HTTP_MAX_CONTENT=1024*100
context=a.threadlocal()
Request=a.class()
function Request.__init__(e,t,a,o)
e.input=a
e.error=o
e.filehandler=nil
e.message={
env=t,
headers={},
params=urldecode_params(t.QUERY_STRING or""),
}
e.parsed_input=false
end
function Request.formvalue(e,t,a)
if not a and not e.parsed_input then
e:_parse_input()
end
if t then
return e.message.params[t]
else
return e.message.params
end
end
function Request.formvaluetable(t,e)
local a={}
e=e and e.."."or"."
if not t.parsed_input then
t:_parse_input()
end
local i=t.message.params[nil]
for t,o in o(t.message.params)do
if t:find(e,1,true)==1 then
a[t:sub(#e+1)]=n(o)
end
end
return a
end
function Request.content(e)
if not e.parsed_input then
e:_parse_input()
end
return e.message.content,e.message.content_length
end
function Request.getcookie(a,e)
return t.header_attribute("cookie; "..(a:getenv("HTTP_COOKIE")or""),e)
end
function Request.getenv(e,t)
if t then
return e.message.env[t]
else
return e.message.env
end
end
function Request.setfilehandler(e,a)
e.filehandler=a
if not e.parsed_input then
return
end
local t,t
for t,e in o(e.message.params)do
if s(e)=="table"then
while e.fd do
local t=e.fd:read(1024)
local o=(not t or t=="")
a(e,t,o)
if o then
e.fd:close()
e.fd=nil
end
end
end
end
end
function Request._parse_input(e)
parse_message_body(
e.input,
e.message,
e.filehandler
)
e.parsed_input=true
end
function close()
if not context.eoh then
context.eoh=true
e.yield(3)
end
if not context.closed then
context.closed=true
e.yield(5)
end
end
function content()
return context.request:content()
end
function formvalue(e,t)
return context.request:formvalue(e,t)
end
function formvaluetable(e)
return context.request:formvaluetable(e)
end
function getcookie(e)
return context.request:getcookie(e)
end
function getenv(e)
return context.request:getenv(e)
end
function setfilehandler(e)
return context.request:setfilehandler(e)
end
function header(t,a)
if not context.headers then
context.headers={}
end
context.headers[t:lower()]=a
e.yield(2,t,a)
end
function prepare_content(e)
if not context.headers or not context.headers["content-type"]then
if e=="application/xhtml+xml"then
if not getenv("HTTP_ACCEPT")or
not getenv("HTTP_ACCEPT"):find("application/xhtml+xml",nil,true)then
e="text/html; charset=UTF-8"
end
header("Vary","Accept")
end
header("Content-Type",e)
end
end
function source()
return context.request.input
end
function status(t,a)
t=t or 200
a=a or"OK"
context.status=t
e.yield(1,t,a)
end
function write(t,a)
if not t then
if a then
i(a)
else
close()
end
return true
elseif#t==0 then
return true
else
if not context.eoh then
if not context.status then
status()
end
if not context.headers or not context.headers["content-type"]then
header("Content-Type","text/html; charset=utf-8")
end
if not context.headers["cache-control"]then
header("Cache-Control","no-cache")
header("Expires","0")
end
if not context.headers["x-frame-options"]then
header("X-Frame-Options","SAMEORIGIN")
end
if not context.headers["x-xss-protection"]then
header("X-XSS-Protection","1; mode=block")
end
if not context.headers["x-content-type-options"]then
header("X-Content-Type-Options","nosniff")
end
context.eoh=true
e.yield(3)
end
e.yield(4,t)
return true
end
end
function splice(a,t)
e.yield(6,a,t)
end
function redirect(e)
if e==""then e="/"end
status(302,"Found")
header("Location",e)
close()
end
function build_querystring(i)
local t,e,n,n={},1,nil,nil
for o,i in o(i)do
t[e+0]=(e==1)and"?"or"&"
t[e+1]=a.urlencode(o)
t[e+2]="="
t[e+3]=a.urlencode(i)
e=e+4
end
return h.concat(t,"")
end
urldecode=a.urldecode
urlencode=a.urlencode
function write_json(e)
a.serialize_json(e,write)
end
function urldecode_params(s,o)
local e,a
local i=o or{}
e=t.urlencoded_parser(function(o,n,s)
if o==e.TUPLE then
a,value=nil,nil
elseif o==e.NAME then
a=t.urldecode(n)
elseif o==e.VALUE and a then
i[a]=t.urldecode(n)or""
end
return true
end)
if e then
e:parse((s or""):match("[^?]*$"))
e:parse(nil)
end
return i
end
function urlencode_params(i)
local e,e
local e,a=1,{}
for i,o in o(i)do
if s(o)=="table"then
local n,n
for n,o in r(o)do
if a[1]then
a[e]="&"
e=e+1
end
a[e+0]=t.urlencode(i)
a[e+1]="="
a[e+2]=t.urlencode(o)
e=e+3
end
else
if a[1]then
a[e]="&"
e=e+1
end
a[e+0]=t.urlencode(i)
a[e+1]="="
a[e+2]=t.urlencode(o)
e=e+3
end
end
return h.concat(a,"")
end
function mimedecode_message_body(m,i,r)
local o,h,e
local d,u=0,c(i.env.CONTENT_LENGTH or nil)
o,err=t.multipart_parser(i.env.CONTENT_TYPE,function(n,a,d)
if n==o.PART_INIT then
e={}
elseif n==o.HEADER_NAME then
h=a:lower()
elseif n==o.HEADER_VALUE and h then
if h:lower()=="content-disposition"and
t.header_attribute(a,nil)=="form-data"
then
e.name=t.header_attribute(a,"name")
e.file=t.header_attribute(a,"filename")
e[1]=e.file
end
if e.headers then
e.headers[h]=a
else
e.headers={[h]=a}
end
elseif n==o.PART_BEGIN then
return not e.file
elseif n==o.PART_DATA and e.name and d>0 then
if e.file then
if r then
r(e,a,false)
i.params[e.name]=i.params[e.name]or e
else
if not e.fd then
e.fd=f.mkstemp(e.name)
end
if e.fd then
e.fd:write(a)
i.params[e.name]=i.params[e.name]or e
end
end
else
e.value=a
end
elseif n==o.PART_END and e.name then
if e.file and i.params[e.name]then
if r then
r(e,"",true)
elseif e.fd then
e.fd:seek(0,"set")
end
else
local t=i.params[e.name]
if s(t)=="table"then
t[#t+1]=e.value or""
elseif t~=nil then
i.params[e.name]={t,e.value or""}
else
i.params[e.name]=e.value or""
end
end
e=nil
elseif n==o.ERROR then
err=a
end
return true
end,HTTP_MAX_CONTENT)
return l.pump.all(m,function(e)
d=d+(e and#e or 0)
if u and d>u+2 then
return nil,"Message body size exceeds Content-Length"
end
if not o or not o:parse(e)then
return nil,err
end
return true
end)
end
function urldecode_message_body(u,n)
local r,a,m,e
local h,d=0,c(n.env.CONTENT_LENGTH or nil)
e=t.urlencoded_parser(function(i,o,h)
if i==e.TUPLE then
a,m=nil,nil
elseif i==e.NAME then
a=t.urldecode(o,t.DECODE_PLUS)
elseif i==e.VALUE and a then
local e=n.params[a]
if s(e)=="table"then
e[#e+1]=t.urldecode(o,t.DECODE_PLUS)or""
elseif e~=nil then
n.params[a]={e,t.urldecode(o,t.DECODE_PLUS)or""}
else
n.params[a]=t.urldecode(o,t.DECODE_PLUS)or""
end
elseif i==e.ERROR then
r=o
end
return true
end,HTTP_MAX_CONTENT)
return l.pump.all(u,function(t)
h=h+(t and#t or 0)
if d and h>d+2 then
return nil,"Message body size exceeds Content-Length"
elseif h>HTTP_MAX_CONTENT then
return nil,"Message body size exceeds maximum allowed length"
end
if not e or not e:parse(t)then
return nil,r
end
return true
end)
end
function parse_message_body(o,e,a)
if e.env.CONTENT_LENGTH or e.env.REQUEST_METHOD=="POST"then
local t=t.header_attribute(e.env.CONTENT_TYPE,nil)
if t=="multipart/form-data"then
return mimedecode_message_body(o,e,a)
elseif t=="application/x-www-form-urlencoded"then
return urldecode_message_body(o,e)
end
local i
if s(a)=="function"then
local t={
name="raw",
encoding=e.env.CONTENT_TYPE
}
i=function(e)
if e then
return a(t,e,false)
else
return a(t,nil,true)
end
end
else
e.content=""
e.content_length=0
i=function(t)
if t then
if(e.content_length+#t)<=HTTP_MAX_CONTENT then
e.content=e.content..t
e.content_length=e.content_length+#t
return true
else
return nil,"POST data exceeds maximum allowed length"
end
end
return true
end
end
while true do
local t,e=l.pump.step(o,i)
if not t and e then
return nil,e
elseif not t then
return true
end
end
return true
end
return false
end
