module("luci.controller.opkg",package.seeall)
function index()
entry({"admin","system","opkg"},template("opkg"),_("Software"),30)
entry({"admin","system","opkg","list"},call("action_list")).leaf=true
entry({"admin","system","opkg","exec"},post("action_exec")).leaf=true
entry({"admin","system","opkg","statvfs"},call("action_statvfs")).leaf=true
entry({"admin","system","opkg","config"},post_on({data=true},"action_config")).leaf=true
end
function action_list(e)
local o=require"luci.util"
local t
if e=="installed"then
t={"/bin/cat","/usr/lib/opkg/status"}
else
local e=nil
local a=io.popen([[sed -rne 's#^lists_dir \S+ (\S+)#\1#p' /etc/opkg.conf /etc/opkg/*.conf 2>/dev/null]],"r")
if a then
e=a:read("*l")
a:close()
end
if not e or#e==""then
e="/tmp/opkg-lists"
end
t={"/bin/sh","-c",[[find %s -type f '!' -name '*.sig' | xargs -r gzip -cd]]%o.shellquote(e)}
end
luci.http.prepare_content("text/plain; charset=utf-8")
luci.sys.process.exec(t,luci.http.write)
end
function action_exec(a,e)
local o=require"luci.sys"
local e={"/bin/opkg","--force-removal-of-dependent-packages"}
local t=luci.http.formvalue("package")
if luci.http.formvalue("autoremove")=="true"then
e[#e+1]="--autoremove"
end
if luci.http.formvalue("overwrite")=="true"then
e[#e+1]="--force-overwrite"
end
e[#e+1]=a
if t then
e[#e+1]=t
end
luci.http.prepare_content("application/json")
luci.http.write_json(o.process.exec(e,true,true))
end
function action_statvfs()
local e=require"nixio.fs"
luci.http.prepare_content("application/json")
luci.http.write_json(e.statvfs("/")or{})
end
function action_config()
local t=require"nixio.fs"
local a=require"luci.jsonc"
local e=luci.http.formvalue("data")
if e then
e=a.parse(e)
if not e then
luci.http.status(400,"Bad Request")
return
end
local a,a
for e,a in pairs(e)do
if type(a)~="string"or
(e~="opkg.conf"and not e:match("^opkg/[^/]+%.conf$"))
then
luci.http.status(400,"Bad Request")
return
end
local e="/etc/%s"%e
if not t.access(e,"w")then
luci.http.status(403,"Permission denied")
return
end
t.writefile(e,a:gsub("\r\n","\n"))
end
luci.http.status(204,"Saved")
else
local a={["opkg.conf"]=t.readfile("/etc/opkg.conf")}
local e=t.dir("/etc/opkg")
if e then
local o
for e in e do
if e:match("%.conf$")then
a["opkg/%s"%e]=t.readfile("/etc/opkg/%s"%e)
end
end
end
luci.http.prepare_content("application/json")
luci.http.write_json(a)
end
end
