module("luci.controller.admin.network",package.seeall)
function index()
local e
e=entry({"admin","network","switch"},view("network/switch"),_("Switch"),20)
e.uci_depends={network={["@switch[0]"]="switch"}}
e=entry({"admin","network","wireless"},view("network/wireless"),_('Wireless'),15)
e.uci_depends={wireless={["@wifi-device[0]"]="wifi-device"}}
e.leaf=true
e=entry({"admin","network","remote_addr"},call("remote_addr"),nil)
e.leaf=true
e=entry({"admin","network","network"},view("network/interfaces"),_("Interfaces"),10)
e.leaf=true
e.subindex=true
e=node("admin","network","dhcp")
e.uci_depends={dhcp=true}
e.target=view("network/dhcp")
e.title=_("DHCP and DNS")
e.order=30
e=node("admin","network","hosts")
e.uci_depends={dhcp=true}
e.target=view("network/hosts")
e.title=_("Hostnames")
e.order=40
e=node("admin","network","routes")
e.target=view("network/routes")
e.title=_("Static Routes")
e.order=50
e=node("admin","network","diagnostics")
e.target=template("admin_network/diagnostics")
e.title=_("Diagnostics")
e.order=60
e=entry({"admin","network","diag_ping"},post("diag_ping"),nil)
e.leaf=true
e=entry({"admin","network","diag_nslookup"},post("diag_nslookup"),nil)
e.leaf=true
e=entry({"admin","network","diag_traceroute"},post("diag_traceroute"),nil)
e.leaf=true
e=entry({"admin","network","diag_ping6"},post("diag_ping6"),nil)
e.leaf=true
e=entry({"admin","network","diag_traceroute6"},post("diag_traceroute6"),nil)
e.leaf=true
end
local function s(a,o)
local t=require"luci.ip"
local e=t.route(a,o)
if not o and e and e.src then
e=t.route(a,e.src:string())
end
return e and e.dev
end
function remote_addr()
local h=require"luci.model.uci"
local e=luci.http.getenv("REMOTE_ADDR")
local t=luci.http.getenv("SERVER_ADDR")
local i=s(e,t)
local a=luci.util.ubus("network.interface","dump")
local o={}
local n={}
local t={
remote_addr=e,
server_addr=t,
inbound_devices={},
inbound_interfaces={}
}
if type(a)=="table"and type(a.interface)=="table"then
for t,e in ipairs(a.interface)do
if type(e)=="table"then
if e.device==i or e.l3_device==i then
n[e.interface]=true
o[i]=true
end
local e=h:get("network",e.interface,"peeraddr")
for t,e in ipairs(e and nixio.getaddrinfo(e)or{})do
local e=s(e.address)
if e then
for a,t in ipairs(a.interface)do
if type(t)=="table"and
(t.device==e or t.l3_device==e)
then
n[t.interface]=true
o[e]=true
end
end
end
end
end
end
end
for e in pairs(n)do
t.inbound_interfaces[#t.inbound_interfaces+1]=e
end
for e in pairs(o)do
t.inbound_devices[#t.inbound_devices+1]=e
end
luci.http.prepare_content("application/json")
luci.http.write_json(t)
end
function diag_command(t,e)
if e and e:match("^[a-zA-Z0-9%-%.:_]+$")then
luci.http.prepare_content("text/plain")
local e=io.popen(t%luci.util.shellquote(e))
if e then
while true do
local e=e:read("*l")
if not e then break end
luci.http.write(e)
luci.http.write("\n")
end
e:close()
end
return
end
luci.http.status(500,"Bad address")
end
function diag_ping(e)
diag_command("ping -c 5 -W 1 %s 2>&1",e)
end
function diag_traceroute(e)
diag_command("traceroute -q 1 -w 1 -n %s 2>&1",e)
end
function diag_nslookup(e)
diag_command("nslookup %s 2>&1",e)
end
function diag_ping6(e)
diag_command("ping6 -c 5 %s 2>&1",e)
end
function diag_traceroute6(e)
diag_command("traceroute6 -q 1 -w 2 -n %s 2>&1",e)
end
